
import numpy as np
import math
from matplotlib.pyplot import *


#Lignes à compléter par le candidat :
# Ne pas indiquer d'unités dans les lignes de script
# Indiquer les valeurs du pKa dans l'ordre décroissant sous la forme de liste :
### une liste peut s'écrire sous cette forme :  x = [9.1,6.4,2.5]
pK=[]
#Indiquer la concentration d'acide en mol/L :
ca =
#Indiquer la concentration de base en mol/L :
cb =
#Indiquer le volume titré d'acide en mL :
va =



def volume(pK,ca,va,cb,ph):
    n = len(pK)
    Ke = 1.0e-14
    h = 10**(-ph)
    c = np.ones(n+1)
    Da = 1
    kk = 1
    for p in range(1,n+1):
        kk *= 10**(-pK[p-1])
        x = h**p/kk
        c[p] = x
        Da += x
    Na = n
    kk = 1
    for p in range(1,n):
        kk *= 10**(-pK[p-1])
        Na += (n-p)*h**p/kk
    y = Ke/h-h
    vb = va*(y+Na*ca/Da)/(cb-y)
    for p in range(n+1):
        c[p] *= ca*va/(va+vb)/Da
    return [vb,c]


def plot_pH(pK,ca,va,cb,vb_max):
    npts = 1000
    pH = np.zeros(npts)
    vb = np.zeros(npts)
    ph_max = 14+math.log10((vb_max*cb-ca*va)/(vb_max+va))
    dph = ph_max/(npts-1)
    for i in range(npts):
        ph = dph*i
        [vb[i],c] = volume(pK,ca,va,cb,ph)
        pH[i] = ph
    plot(vb,pH)
    axis([0,vb_max,0,14])
    xlabel("vB")
    ylabel("pH")


def plot_frac(pK,ca,va,cb,vb_max):
    npts = 1000
    n = len(pK)
    vb = np.zeros(npts)
    frac = np.zeros((n+1,npts))
    ph_max = 14+math.log10((vb_max*cb-ca*va)/(vb_max+va))
    dph = ph_max/(npts-1)
    for i in range(npts):
        ph = dph*i
        [vb[i],c] = volume(pK,ca,va,cb,ph)
        for p in range(n+1):
            frac[p][i] = c[p]*(vb[i]+va)/(ca*va)*100
    for p in range(0,n+1):
        s1 = "H_{"+str(p)+"}"
        if p==0:
            s1 = ""
        elif p==1:
            s1 = "H"
        s2 = "A^{"+str(n-p)+"-}"
        if n-p==0:
            s2 = "A"
        elif n-p==1:
            s2 = "A^-"
        plot(vb,frac[p],label="$"+s1+s2+"$")

    axis([0,vb_max,0,100])
    xlabel("vB")
    ylabel("%")





figure(figsize=(10,6))
vb_max = 150.0
plot_pH(pK,ca,va,cb,vb_max)
grid()
title("Dosage théorique de l'acide citrique par la soude")
show()